<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

namespace phpbb\db\migration\data\v400;

use phpbb\db\migration\migration;

class remove_smtp_auth_method extends migration
{
	public function effectively_installed()
	{
		return !$this->config->offsetExists('smtp_auth_method');
	}

	public static function depends_on()
	{
		return [
			'\phpbb\db\migration\data\v400\dev',
		];
	}

	public function update_data()
	{
		return [
			['config.remove', ['smtp_auth_method']],
		];
	}

	public function revert_data()
	{
		return [
			['config.add', ['smtp_auth_method', 'PLAIN']],
		];
	}
}
